<%@ Control Language="c#" AutoEventWireup="false" Codebehind="Search.ascx.cs" Inherits="Mediachase.UI.Web.Modules.Search" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="sep" src="..\Modules\Separator2.ascx"%>
<script language="javascript">

function ObjectClick(Id, TypeId, evt)
{
	evt = (evt) ? evt : ((window.event) ? event : null);
	if (evt)
	{
		var src = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if (src && src.type == "image") return;
	}

	var loc = window.top.right.location;
	if (TypeId == 1) 
		loc.href = "../Directory/UserView.aspx?UserID=" + Id;
	else if (TypeId == 2) 
		loc.href = "../Directory/Directory.aspx?Tab=0&SGroupId=" + Id;
	else if (TypeId == 3) 
		loc.href = "../Projects/ProjectView.aspx?ProjectID=" + Id;
	else if (TypeId == 4) 
		loc.href = "../Events/EventView.aspx?EventId=" + Id;
	else if (TypeId == 5) 
		loc.href = "../Tasks/TaskView.aspx?TaskId=" + Id;
	else if (TypeId == 6) 
		loc.href = "../ToDo/ToDoView.aspx?ToDoId=" + Id;
	else if (TypeId == 7) 
		loc.href = "../Incidents/IncidentView.aspx?IncidentId=" + Id;
	else if (TypeId == 15) 
		loc.href = "../Lists/ListView.aspx?ListId=" + Id;
	else if (TypeId == 8)		// File
		loc.href = "../FileStorage/DownloadFile.aspx?Id=" + Id;
	else if (TypeId == 16) 
		loc.href = "../Documents/DocumentView.aspx?DocumentId=" + Id;
}

function checkKey(e) 
{ 
	var _key = e.keyCode ? e.keyCode : e.which ? e.which : e.charCode;
	try {
		if (_key == 13)
			<%= Page.GetPostBackClientEvent(btnSearch, "") %>
		else
			return true;
	}
	catch (e) {return true;}
}
</script>

<table cellpadding="5" cellspacing="0" class="text">
	<tr>
		<td><%=LocRM.GetString("SearchString") %>:</td>
		<td>
			<asp:TextBox CssClass="text" Width="150" ID="tbSearchstr" Runat="server" onkeypress="return checkKey(event);"></asp:TextBox>
			<asp:ImageButton Runat="server" id="btnSearch" Width="16" Height="16" ImageUrl="~/layouts/images/search.gif" ImageAlign="AbsMiddle"></asp:ImageButton>
		</td>
	</tr>
</table>

<ibn:sep id="Sep1" runat="server"></ibn:sep>
<asp:Panel ID="Pan1" Runat="server">
	<asp:DataGrid id="dgProjects"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "ProjectId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.project %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
								(#<%# DataBinder.Eval(Container.DataItem, "ProjectId") %>)
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>		
</asp:Panel>

<ibn:sep id="Sep2" runat="server"></ibn:sep>
<asp:Panel ID="Pan2" Runat="server">
	<asp:DataGrid id="dgTasks"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "ItemId") %>, <%# ((int)DataBinder.Eval(Container.DataItem, "IsToDo") == 1) ? (int)Mediachase.IBN.Business.ObjectTypes.todo : (int)Mediachase.IBN.Business.ObjectTypes.task %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep4" runat="server"></ibn:sep>
<asp:Panel ID="Pan4" Runat="server">
	<asp:DataGrid id="dgEvents"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "EventId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.calendar_entry %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep5" runat="server"></ibn:sep>
<asp:Panel ID="Pan5" Runat="server">
	<asp:DataGrid id="dgIncidents"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "IncidentId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.incident %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %> (#<%# DataBinder.Eval(Container.DataItem, "IncidentId") %>)
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep6" runat="server"></ibn:sep>
<asp:Panel ID="Pan6" Runat="server">
	<asp:DataGrid id="dgFiles"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "Id") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.asset %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep7" runat="server"></ibn:sep>
<asp:Panel ID="Pan7" Runat="server">
	<asp:DataGrid id="dgLists"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "ListId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.list %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep8" runat="server"></ibn:sep>
<asp:Panel ID="Pan8" Runat="server">
	<asp:DataGrid id="dgUsers"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "UserId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.user %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "FirstName") %> <%# DataBinder.Eval(Container.DataItem, "LastName") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep9" runat="server"></ibn:sep>
<asp:Panel ID="Pan9" Runat="server">
	<asp:DataGrid id="dgGroups"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "GroupId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.secure_group %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "GroupName") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>

<ibn:sep id="Sep10" runat="server"></ibn:sep>
<asp:Panel ID="Pan10" Runat="server">
	<asp:DataGrid id="dgDocuments"  Runat="server" AutoGenerateColumns="False" AllowPaging="false" AllowSorting="False" CellSpacing="0" Width="100%" GridLines="Horizontal" borderwidth="0px" cellpadding="0"	ShowHeader="false" EnableViewState="True" CssClass="ibn-propertysheet">
		<Columns>
			<asp:TemplateColumn>
				<ItemTemplate>
					<table cellpadding="0" cellspacing="0" width="100%" class="ibn-row" 
					onmouseover="this.className='ibn-rowHover'" onmouseout="this.className='ibn-row'" 
					onclick='ObjectClick(<%# DataBinder.Eval(Container.DataItem, "DocumentId") %>, <%= (int)Mediachase.IBN.Business.ObjectTypes.document %>, event)'>
						<tr>
							<td width="30px"></td>
							<td>
								<%# DataBinder.Eval(Container.DataItem, "Title") %>
							</td>
						</tr>
					</table>
				</ItemTemplate>
			</asp:TemplateColumn>
		</Columns>
	</asp:DataGrid>	
</asp:Panel>